/*****************************************************************************************************************************/

IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_VD_PROC_RsProcVdMes')
BEGIN
	DROP TABLE EST_PROD_CPL_VD_PROC_RsProcVdMes
END

GO

CREATE TABLE  EST_PROD_CPL_VD_PROC_RsProcVdMes (CD_EMP    TINYINT
												, CD_FILIAL INT
												, CD_PROD   INT
												, ANO       INT
												, MES       TINYINT
												, ANO_MES	INT
												CONSTRAINT [PK_EST_PROD_CPL_VD_PROC_RsProcVdMes] PRIMARY KEY CLUSTERED (CD_PROD, CD_FILIAL, ANO,MES, CD_EMP)
												);

GO
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME= 'EST_PROD_CPL_VD_PROC_RsMovimentacao')
BEGIN
	DROP TABLE EST_PROD_CPL_VD_PROC_RsMovimentacao
END
GO
CREATE NONCLUSTERED INDEX IX_EST_PROD_CPL_VD_PROC_RsProcVdMes_CD_FILIAL
	ON [dbo].[EST_PROD_CPL_VD_PROC_RsProcVdMes] ([CD_FILIAL])
		INCLUDE ([ANO],[MES])
GO
 
go 
 
truncate table EST_PROD_CPL_VD_PROC_RsProcVdMes 
go
/****** Object:  StoredProcedure [dbo].[P_EST_PROD_CPL_VD_PROC]    Script Date: 12/16/2013 10:52:22 ******/
IF EXISTS(SELECT * FROM sys.objects
			WHERE  object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_VD_PROC]') AND type IN(N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_CPL_VD_PROC];
GO
GO

--EXEC P_EST_PROD_CPL_VD_PROC 1,1,0,201711
CREATE PROCEDURE P_EST_PROD_CPL_VD_PROC @CD_EMP         INT
									  , @CD_FILIAL      INT
									  , @FLAG_DT_ATUAL  INT = 0
									  , @ANO_MES_REPROC INT = 0

AS
BEGIN

/*
	Formato do @ANO_MES_REPROC =201709
	Seis posicoes 
*/

SET NOCOUNT ON;
	
	 
	DECLARE   @ANO_MES INT, @sqlCmd varchar (8000), @VariosMeses tinyint; 
	SET @ANO_MES = YEAR(getdate()) * 100 + MONTH(getdate());

/*****************************************************************************************************************/
	CREATE TABLE #EST_PROD_CPL_VD_PROC_RsMovimentacao(CD_EMP        INT
								, CD_FILIAL     INT
								, CD_PROD       INT
								, ANO           INT
								, MES           INT
								, TIPO_VENDA    INT
								, QT_VD         MONEY
								, VLR_VD        MONEY
								, ANO_MES       INT
								, VLR_CUSTO_MD  MONEY
								, VLR_CUSTO     MONEY
								, VLR_CUSTO_GER MONEY
								 PRIMARY KEY CLUSTERED (CD_PROD, CD_FILIAL, ANO, MES,TIPO_VENDA, CD_EMP)
								);
/*****************************************************************************************************************/

	declare @RsAnoMesProc table (CD_EMP    INT
								, CD_FILIAL INT
								, ANO_MES   INT
								);

	delete from EST_PROD_CPL_VD_PROC_RsProcVdMes	where cd_emp = @cd_emp and cd_filial =@cd_filial; 

/*****************************************************************************************************************/
/*****************************************************************************************************************/
/*****************************************************************************************************************/
	set @VariosMeses = 0;

	IF @ANO_MES_REPROC = 0
	BEGIN
		IF @FLAG_DT_ATUAL = 0
			BEGIN
				INSERT INTO @RsAnoMesProc
				SELECT DISTINCT
					@CD_EMP
					, @CD_FILIAL
					, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES
				FROM
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
				WHERE  
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES = @ANO_MES
				GROUP BY
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES;
			END;
			ELSE
			BEGIN
				set @VariosMeses = 1;
				INSERT INTO @RsAnoMesProc
				SELECT DISTINCT
					@CD_EMP
					, @CD_FILIAL
					, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES
				FROM
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
				WHERE  
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES <> @ANO_MES
				GROUP BY
					EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES;
			END;
	END;
	ELSE
	BEGIN
		INSERT INTO @RsAnoMesProc
		SELECT
			@CD_EMP
			, @CD_FILIAL
			, @ANO_MES_REPROC;
	END;

/*****************************************************************************************************************/
/*****************************************************************************************************************/
/*****************************************************************************************************************/

		 DECLARE @ANO_MES_PROC INT;

		 DECLARE cProcMoviConsolidacaoProd CURSOR FAST_FORWARD
		 FOR SELECT
					ANO_MES
			 FROM
				 @RsAnoMesProc
			 ORDER BY ANO_MES DESC;
		 OPEN cProcMoviConsolidacaoProd;

		 FETCH NEXT FROM cProcMoviConsolidacaoProd INTO @ANO_MES_PROC;
		 WHILE @@FETCH_STATUS = 0
			 BEGIN
				 PRINT 'Processando ano\mes.: '+CONVERT(CHAR(10), @ANO_MES_PROC)+' '+CONVERT(VARCHAR(8), GETDATE(), 114);

				 IF @ANO_MES_REPROC = 0
					 BEGIN
						 UPDATE EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
						   SET
							   DT_PROD_FILIAL_ANO_MES = GETDATE()
							 , FILIAL_PROC = @CD_FILIAL
						 WHERE
							   ANO_MES = @ANO_MES_PROC;

						if @VariosMeses=1 
						begin	   
							SET @SqlCmd = '	INSERT INTO EST_PROD_CPL_VD_PROC_RsProcVdMes
										SELECT DISTINCT
											  f.CD_EMP
											, f.CD_FILIAL
											, EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD
											, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO
											, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.MES
											, '+ convert(varchar,@ANO_MES_PROC) + '
										FROM
											EST_PROD_CPL_VD_LOTE_PROC_PENDENTE 
											INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD ON EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_CTR
											INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL F ON EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR =  F.CD_CTR

										WHERE  
											EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES = '+ convert(varchar,@ANO_MES_PROC) + '   
											AND F.CD_FILIAL = ' +convert(varchar, @CD_FILIAL) +  '
											AND F.CD_EMP = 1
										GROUP BY
											  EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD
											, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO
											, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.MES
											, f.CD_EMP
											, f.CD_FILIAL;'
							exec (@SqlCmd); 
						end
						else
						begin
							INSERT INTO EST_PROD_CPL_VD_PROC_RsProcVdMes
							SELECT DISTINCT
								p.CD_EMP
								, p.CD_FILIAL
								, EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD
								, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO
								, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.MES
								, @ANO_MES_PROC
							FROM
								EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
								INNER JOIN @RsAnoMesProc p ON EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES = P.ANO_MES
								INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD ON EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_CTR
								INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL F ON EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR =  F.CD_CTR

							WHERE  
								EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO_MES = @ANO_MES_PROC
								AND F.CD_FILIAL = @CD_FILIAL
								AND F.CD_EMP = 1
							GROUP BY
								EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_PROD
								, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.ANO
								, EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.MES
								, p.CD_EMP
								, p.CD_FILIAL;
						end
					END;
					ELSE
					BEGIN
						INSERT INTO EST_PROD_CPL_VD_PROC_RsProcVdMes
						SELECT
							EST_PROD_CPL.CD_EMP
							, EST_PROD_CPL.CD_FILIAL
							, EST_PROD_CPL.CD_PROD
							, LEFT(@ANO_MES_REPROC, 4)
							, RIGHT(@ANO_MES_REPROC, 2)
							, @ANO_MES_PROC
						FROM
							EST_PROD_CPL
							INNER JOIN @RsAnoMesProc p ON EST_PROD_CPL.CD_EMP = P.CD_EMP
														AND EST_PROD_CPL.CD_FILIAL = P.CD_FILIAL
						WHERE  
								EST_PROD_CPL.CD_FILIAL = @CD_FILIAL
							AND EST_PROD_CPL.CD_EMP = 1;
					END;

			PRINT 'Deletando consolidado filial '+CONVERT(VARCHAR(8), GETDATE(), 114);

			SET @SqlCmd = '			
			DELETE c
			FROM EST_PROD_CPL_VD c
				INNER JOIN EST_PROD_CPL_VD_PROC_RsProcVdMes procM ON c.CD_EMP = procM.CD_EMP
												AND c.CD_FILIAL = procM.CD_FILIAL
												AND c.CD_PROD = procM.CD_PROD
												AND c.ANO = procM.ANO
												AND c.MES = procM.MES
			WHERE
				C.CD_EMP = 1 AND C.CD_FILIAL = '+convert(varchar, @CD_FILIAL)  ;
			
			exec (@sqlCmd);
			
			PRINT 'Vendas de cupom fiscal e nota fiscal  '+CONVERT(VARCHAR(8), GETDATE(), 114);
			--Vendas de cupom fiscal e nota fiscal		   
			INSERT INTO #EST_PROD_CPL_VD_PROC_RsMovimentacao(CD_EMP
											, CD_FILIAL
											, CD_PROD
											, ANO
											, MES
											, TIPO_VENDA
											, QT_VD
											, VLR_VD
											, ANO_MES
											, VLR_CUSTO_MD
											, VLR_CUSTO
											, VLR_CUSTO_GER)
				 SELECT
						v.CD_EMP
					  , v.CD_FILIAL
					  , i.CD_PROD
					  , c.ANO_MOVIMENTO
					  , c.MES_MOVIMENTO
					  , 0 AS TIPO_VENDA
					  , SUM(i.QTDE_ITENS)
					  , SUM(i.VLR_VD_LIQ)
					  , c.ANO_MOVIMENTO * 100 + c.MES_MOVIMENTO
					  , SUM(i.VLR_CUSTO_MD)
					  , SUM(i.VLR_CUSTO)
					  , SUM(i.VLR_CUSTO_GER)
				 FROM
					 EST_MOVIMENTO_VENDAS_PRODUTOS i
					 INNER JOIN EST_MOVIMENTO_VENDAS v ON i.CD_CTR_VENDAS = v.CD_CTR_VENDAS
					 INNER JOIN GLB_DT_MOVIMENTO c ON  v.CD_CTR_DT_MOVIMENTO = c.CD_CTR_DT_MOVIMENTO
					 INNER JOIN EST_PROD_CPL_VD_PROC_RsProcVdMes procM ON i.CD_EMP = procM.CD_EMP
													  AND V.CD_FILIAL = procM.CD_FILIAL
													  AND i.CD_PROD = procM.CD_PROD
													  AND c.ANO_MOVIMENTO = procM.ANO
													  AND c.MES_MOVIMENTO = procM.MES
				 WHERE		i.CD_EMP = 1
						AND v.CD_FILIAL = @CD_FILIAL
						AND v.TIPO_VENDA IN(0, 10, 3)
				 GROUP BY
						  v.CD_EMP
						, i.CD_PROD
						, v.CD_FILIAL
						, c.ANO_MOVIMENTO
						, c.MES_MOVIMENTO;	

			PRINT 'Gravando resultado final '+CONVERT(VARCHAR(8), GETDATE(), 114);
			INSERT INTO                EST_PROD_CPL_VD( CD_EMP
															  , CD_FILIAL
															  , CD_PROD
															  , ANO
															  , MES
															  , TIPO_VENDA
															  , QT_VD
															  , VLR_VD
															  , ANO_MES
															  , VLR_CUSTO_MD
															  , VLR_CUSTO
															  , VLR_CUSTO_GER)
				 SELECT
						i.CD_EMP
					  , i.CD_FILIAL
					  , i.CD_PROD
					  , i.ANO
					  , i.MES
					  , i.TIPO_VENDA
					  , SUM(i.QT_VD)
					  , SUM(i.VLR_VD)
					  , i.ANO_MES
					  , SUM(i.VLR_CUSTO_MD)
					  , SUM(i.VLR_CUSTO)
					  , SUM(i.VLR_CUSTO_GER)
				 FROM
					 #EST_PROD_CPL_VD_PROC_RsMovimentacao i
				 where cd_emp = @cd_emp and cd_filial =@cd_filial AND ANO_MES =@ANO_MES_PROC
				 GROUP BY
						i.CD_EMP
						, i.CD_PROD
						, i.CD_FILIAL
						, i.ANO
						, i.MES
						, i.TIPO_VENDA
						, i.ANO_MES; 

				delete from EST_PROD_CPL_VD_PROC_RsProcVdMes	where cd_emp = @cd_emp and cd_filial =@cd_filial AND ANO_MES =@ANO_MES_PROC;
				delete from #EST_PROD_CPL_VD_PROC_RsMovimentacao where cd_emp = @cd_emp and cd_filial =@cd_filial AND ANO_MES =@ANO_MES_PROC;


				FETCH NEXT FROM cProcMoviConsolidacaoProd INTO @ANO_MES_PROC;
			END;
			 
		 CLOSE cProcMoviConsolidacaoProd;
		 DEALLOCATE cProcMoviConsolidacaoProd;

		 PRINT 'Fim rotina P_EST_PROD_CPL_VD_PROC '+CONVERT(VARCHAR(8), GETDATE(), 114);
		 
	 END;